Thanks for using the DEE2 request feature!

# Contents
In this folder, you will see several files:

## GeneCountMatrix.tsv     
A tab separated file of gene level expression counts generated by STAR.
The different columns represent different SRA run accession numbers and rows represent Ensembl genes. 

## GeneInfo.tsv
A tab separated file of Ensembl genes mapped to their gene symbol as well as the length of gene, as calculated by GTFtools.
This file might be useful if you need to convert the gene IDs from accession numbers to symbols for downstream pathway analysis or need to calculate FPKM for genes.
Each row represents one Ensembl gene.

## TxCountMatrix.tsv
A tab separated file containng transcript-level expression counts generated by Kallisto.
The different columns represent different SRA runs and the rows represent different Ensembl transcripts.
These counts can be fractional, ie: not integers, so be wary that some analyses (eg: DESeq2) require these values be rounded to integers.

## TxInfo.tsv 
A tab separated file of Ensembl transcripts and their corresponding Ensembl gene IDs, gene symbols and transcript length.
This file will be helpful for downstream analysis such as pathway analysis and calculating FPKM.

## QC_Matrix.tsv
A tab separated file containing quality control information collected during data processing.
These metrics are used to determine the QC_summary seen in the MetadataSummary.tsv file.
Each column represents an SRA run and each row represents a different quality metric.

## logs/
A folder of logs, each file corresponding to an SRA run accession number.
Logs include Fastqc stats, Skewer trimming stats, STAR and Kallisto mapping stats.

# What about metadata

As these data are not yet incorporated into the main DEE2 dataset, the metadata isn't available from us.
Rather, we recommend using the [SRA website](https://www.ncbi.nlm.nih.gov/sra).
Search with your SRP number and then use the Run Selector tool to obtain the metadata you need.

## Help and feedback
Contact us by email: mark.ziemann[at]gmail.com

# Citation
Please cite our article when publishing your work:

Ziemann M, Kaspi A, El-Osta A. Digital expression explorer 2: a repository of uniformly processed RNA sequencing data. Gigascience. 2019 Apr 1;8(4):giz022. doi: 10.1093/gigascience/giz022. PMID: 30942868; PMCID: PMC6446219.

